%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%  Direction of the steepest ascent


clear all;
close all;
syms x y

h = 0.1*x*log(0.001*y);  % x, y in meters
[dirx,diry] = gradCar(h);
dir = [dirx,diry];
fprintf('\nExpression for grad h (x, y in meters) is: ');
pretty(dir);
%a, b in meters
a = 3000;
b = 3000;
direction = double(limit(limit(dir,x,a),y,b));
unit = direction/vectorMag(direction);
fprintf('\nDirection of steepest ascent (unit vector) is: [%.4f %.4f]',unit);
%b
angle = atan(vectorMag(direction))*180/pi;
fprintf('\nAscent angle in degrees is: %.2f',angle);